import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";
import { queryResponse } from "../../util/processResponse.js";

const initialState = {
    data: {},
    deliveryAddress: {},
    loading: false,
    activeId: null,
};

export const getShipping = createAsyncThunk(
    "deliveryOption/getShipping",
    async (params) => {
        const { access_token, url } = params;
        const response = await queryResponse(url, "GET", access_token);
        return response;
    }
);

const getShippingSlice = createSlice({
    name: "deliveryOption",
    initialState,
    reducers: {
        setDeliveryAddress: (state, { payload }) => {
            state.deliveryAddress = payload;
            state.activeId = payload?.id;
        },
        setActiveId: (state, { payload }) => {
            state.activeId = payload;
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getShipping.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getShipping.fulfilled, (state, { payload }) => {
            const { records, status } = payload;
            if (status?.code == 200) {
                state.data = records?.data;
            }
            state.loading = false;
        });
        builder.addCase(getShipping.rejected, (state) => {
            state.loading = false;
        });
    },
});

export const { setDeliveryAddress, setActiveId } = getShippingSlice.actions;
export default getShippingSlice.reducer;
